#ifndef _USBSER_H
#define _USBSER_H

/*
 * Baud rate and default timeout
 */
#define DEFAULT_BAUD_RATE 9600
#define DEFAULT_TIMEOUT	  2000

/*
 * CMSPAR, some architectures can't have space and mark parity.
 */
#ifndef CMSPAR
#define CMSPAR 0
#endif

/*
 * Major and minor numbers.
 */
#define USBSER_TTY_MAJOR  170
#define USBSER_TTY_MINORS 256

#define USBSER_MINOR_INVALID USBSER_TTY_MINORS

#define USB_MINOR_BASE 70

/*
 * Requests.
 */
#define USB_RT_USBSER (USB_TYPE_CLASS | USB_RECIP_INTERFACE)

#define CMD_R  0x95
#define CMD_W  0x9A
#define CMD_C1 0xA1
#define CMD_C2 0xA4
#define CMD_C3 0x05
#define CMD_C4 0xA8
#define CMD_C5 0x5E
#define CMD_C6 0x5F

#define USBSER_CTO_O  0x10
#define USBSER_CTO_D  0x20
#define USBSER_CTO_R  0x40
#define USBSER_CTO_A  0x80
#define USBSER_CTI_C  0x01
#define USBSER_CTI_DS 0x02
#define USBSER_CTI_R  0x04
#define USBSER_CTI_DC 0x08
#define USBSER_CTI_ST 0x0f

#define USBSER_CTT_M 0x08
#define USBSER_CTT_F 0x44
#define USBSER_CTT_P 0x04
#define USBSER_CTT_O 0x02

#define USBSER_LO 0x02
#define USBSER_LE 0x04
#define USBSER_LB
#define USBSER_LP 0x00
#define USBSER_LF 0x40
#define USBSER_LM 0x08

#define USBSER_L_R_CT 0x80
#define USBSER_L_R_CL 0x04
#define USBSER_L_R_T  0x08

#define USBSER_L_E_R 0x80
#define USBSER_L_E_T 0x40
#define USBSER_L_P_S 0x38
#define USBSER_L_P_M 0x28
#define USBSER_L_P_E 0x18
#define USBSER_L_P_O 0x08
#define USBSER_L_SB  0x04
#define USBSER_L_C8  0x03
#define USBSER_L_C7  0x02
#define USBSER_L_C6  0x01
#define USBSER_L_C5  0x00

#define USBSER_N_B  0x80
#define USBSER_N_AB 0x10

#define USBSER_NW 2
#define USBSER_NR 2

#define IOID 0x13572468

struct usbser_wb {
	unsigned char *buf;
	dma_addr_t dmah;
	int len;
	int use;
	struct urb *urb;
	struct usbser *instance;
};

struct usbser_rb {
	int size;
	unsigned char *base;
	dma_addr_t dma;
	int index;
	struct usbser *instance;
};

struct usb_usbser_line_coding {
	__u32 dwDTERate;
	__u8 bCharFormat;
#define USB_USBSER_1_STOP_BITS	0
#define USB_USBSER_1_5_STOP_BITS 1
#define USB_USBSER_2_STOP_BITS	2

	__u8 bParityType;
#define USB_USBSER_NO_PARITY    0
#define USB_USBSER_ODD_PARITY   1
#define USB_USBSER_EVEN_PARITY  2
#define USB_USBSER_MARK_PARITY  3
#define USB_USBSER_SPACE_PARITY 4

	__u8 bDataBits;
} __attribute__((packed));

typedef enum {

	CHIP_USBSER,
} CHIPTYPE;

struct usbser {
	struct usb_device *dev;	       /* the corresponding usb device */
	struct usb_interface *control; /* control interface */
	struct usb_interface *data;    /* data interface */
	struct tty_port port;	       /* our tty port data */
	struct urb *ctrlurb;	       /* urbs */
	u8 *ctrl_buffer;	       /* buffers of urbs */
	dma_addr_t ctrl_dma;	       /* dma handles of buffers */
	struct usbser_wb wb[USBSER_NW];
	unsigned long read_urbs_free;
	struct urb *read_urbs[USBSER_NR];
	struct usbser_rb read_buffers[USBSER_NR];
	int rx_buflimit;
	int rx_endpoint;
	spinlock_t read_lock;
	int write_used; /* number of non-empty write buffers */
	int transmitting;
	spinlock_t write_lock;
	struct mutex mutex;
	bool disconnected;
	struct usb_usbser_line_coding line; /* bits, stop, parity */
	struct work_struct work;	   /* work queue entry for line discipline waking up */
	unsigned int ctrlin;		   /* input control lines (DCD, DSR, RI, break, overruns) */
	unsigned int ctrlout;		   /* output control lines (DTR, RTS) */
	struct async_icount iocount;	   /* counters for control line changes */
	struct async_icount oldcount;	   /* for comparison of counter */
	wait_queue_head_t wioctl;	   /* for ioctl */
	unsigned int writesize;		   /* max packet size for the output bulk endpoint */
	unsigned int readsize, ctrlsize;   /* buffer sizes for freeing */
	unsigned int minor;		   /* usbser minor number */
	unsigned char clocal;		   /* termios CLOCAL */
	unsigned int susp_count;	   /* number of suspended interfaces */
	u8 bInterval;
	struct usb_anchor delayed; /* writes queued for a device about to be woken */
	unsigned long quirks;
	u8 iface;
	u8 num_ports;
	struct usb_interface *io_intf;
	struct kref kref;
	CHIPTYPE chiptype;
	bool iosupport;
	u16 idVendor;
	u16 idProduct;
	u8 gpio5dir;
	u32 io_id;
};

#define CDC_DATA_INTERFACE_TYPE 0x0a

/* constants describing various quirks and errors */
#define NO_UNION_NORMAL		 BIT(0)
#define SINGLE_RX_URB		 BIT(1)
#define NO_CAP_LINE		 BIT(2)
#define NO_DATA_INTERFACE	 BIT(4)
#define IGNORE_DEVICE		 BIT(5)
#define QUIRK_CONTROL_LINE_STATE BIT(6)
#define CLEAR_HALT_CONDITIONS	 BIT(7)

#endif
